# Generated by Django 3.0.14 on 2022-07-14 17:18

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('courses', '0072_coursemodule_moe_id'),
    ]

    operations = [
        migrations.CreateModel(
            name='ActionEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('status', models.CharField(choices=[('pending', 'Ожидает'), ('processing', 'В обработке'), ('completed', 'Завершено'), ('cancelled', 'Отменено'), ('error', 'Ошибка')], default='pending', max_length=20, verbose_name='статус')),
                ('description', models.TextField(verbose_name='описание')),
                ('message', models.TextField(blank=True, verbose_name='результат действия')),
                ('event_type', models.CharField(choices=[('add_achievement', 'Выдача ачивки')], default='add_achievement', max_length=50, verbose_name='тип действия')),
                ('completion_date', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='дата завершения действия')),
            ],
            options={
                'verbose_name': 'событие',
                'verbose_name_plural': 'события',
            },
        ),
        migrations.CreateModel(
            name='AddAchievementEvent',
            fields=[
                ('actionevent_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='actions.ActionEvent')),
                ('achievement_id', models.IntegerField(verbose_name='ID ачивки')),
                ('level', models.IntegerField(blank=True, null=True, verbose_name='уровень ачивки')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='add_achievement_events', to='courses.Course', verbose_name='курс')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='add_achievement_events', to=settings.AUTH_USER_MODEL, verbose_name='пользователь')),
            ],
            options={
                'verbose_name': 'выдача ачивки',
                'verbose_name_plural': 'выдача ачивок',
            },
            bases=('actions.actionevent',),
        ),
    ]
