# Generated by Django 3.0.14 on 2022-07-28 10:16

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('courses', '0073_service_account_course'),
        ('actions', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CourseTrigger',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_active', models.BooleanField(default=True, verbose_name='активна')),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('description', models.TextField(blank=True, verbose_name='описание')),
                ('action_type', models.CharField(choices=[('add_achievement', 'Выдать ачивку')], max_length=50, verbose_name='тип действия')),
                ('trigger_type', models.CharField(choices=[('course_passed', 'Курс пройден')], max_length=50, verbose_name='тип триггера')),
                ('parameters', django.contrib.postgres.fields.jsonb.JSONField(default=dict, verbose_name='параметры')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='triggers', to='courses.Course', verbose_name='курс')),
            ],
            options={
                'verbose_name': 'триггер курса',
                'verbose_name_plural': 'триггеры курсов',
            },
        ),
    ]
