from django.db import models, transaction
from django.dispatch import receiver

from .models import AddAchievementEvent
from .tasks import add_achievement_task


@receiver(signal=models.signals.post_save, sender=AddAchievementEvent)
def add_achievement_event_post_save_handler(instance: AddAchievementEvent, created: bool, **kwargs):
    if created and instance.status == AddAchievementEvent.Status.PENDING:
        transaction.on_commit(lambda: add_achievement_task.delay(add_achievement_event_id=instance.id))
