import logging

from django.utils.translation import gettext_lazy as _

from lms.courses.models import CourseStudent

from ..contrib.achievery.client import achievery_client
from .models import AddAchievementEvent, CourseTrigger

log = logging.getLogger(__name__)


def add_achievement(add_achievement_event: AddAchievementEvent):
    if add_achievement_event.status != AddAchievementEvent.Status.PROCESSING:
        add_achievement_event.status = AddAchievementEvent.Status.PROCESSING
        add_achievement_event.save()

    achievement_id = add_achievement_event.achievement_id
    login = add_achievement_event.user.username

    response = achievery_client.add_user_achievement(
        achievement_id=achievement_id,
        login=login,
    )
    level = response['level']

    add_achievement_event.level = level
    add_achievement_event.message = str(response)
    add_achievement_event.status = AddAchievementEvent.Status.COMPLETED
    add_achievement_event.save()

    log.info(_(f"Ачивка {achievement_id} уровня {level} выдана пользователю {login}"))


def create_add_achivement_event(course_trigger: CourseTrigger, student_id: int):
    achievement_id = course_trigger.parameters.get('achievement_id')
    if not achievement_id:
        log.warning(f"Отсутствует achievement_id в параметрах триггера {course_trigger.id}")
        return
    user_id = CourseStudent.objects.only('user_id').get(id=student_id).user_id
    AddAchievementEvent.objects.create(
        description="Выдача ачивки {} пользователю {} за прохождение курса {}".format(
            achievement_id, user_id, course_trigger.course_id
        ),
        achievement_id=achievement_id,
        course_id=course_trigger.course_id,
        user_id=user_id,
    )


def start_course_passed_trigger_actions(*, course_id: int, student_id: int):
    course_triggers = CourseTrigger.objects.filter(
        course_id=course_id,
        trigger_type=CourseTrigger.TriggerType.COURSE_PASSED,
        is_active=True,
    )

    for course_trigger in course_triggers:
        course_trigger.start(student_id=student_id)
