import logging

from django.db import transaction
from django.utils.translation import gettext_lazy as _

from config import celery_app as app

from .models import AddAchievementEvent

from.services import start_course_passed_trigger_actions

log = logging.getLogger(__name__)


@app.task(bind=True)
@transaction.atomic
def add_achievement_task(self, add_achievement_event_id):
    add_achievement_event = AddAchievementEvent.objects.filter(
        id=add_achievement_event_id
    ).select_for_update().first()

    if not add_achievement_event:
        log.error(_(f"AddAchievementEvent {add_achievement_event_id} не найден"))
        return

    try:
        add_achievement_event.process()
    except Exception as exc:
        log.warning(exc)
        add_achievement_event.message = exc
        add_achievement_event.status = AddAchievementEvent.Status.ERROR
        add_achievement_event.save()


@app.task(bind=True)
def start_course_passed_trigger_actions_task(self, *, course_id: int, student_id: int):
    start_course_passed_trigger_actions(course_id=course_id, student_id=student_id)
