from django_admin_listfilter_dropdown.filters import RelatedOnlyDropdownFilter

from django.contrib import admin

from lms.assignments.models import Assignment, AssignmentStudentResult


@admin.register(Assignment)
class AssignmentAdmin(admin.ModelAdmin):
    search_fields = (
        'id', 'name', 'course__name',
    )

    list_display = ('name', 'course', 'is_active')
    list_select_related = ('course',)
    list_filter = (
        ('course', RelatedOnlyDropdownFilter),
        'is_active',
    )
    raw_id_fields = ('course',)

    fields = (
        'course', 'name', 'description', 'is_active',
    )


@admin.register(AssignmentStudentResult)
class AssignmentStudentResultAdmin(admin.ModelAdmin):
    search_fields = (
        'assignment__name', 'course__name', 'student__user__username',
    )
    list_display = ('assignment', 'course', 'student', 'is_completed')
    list_select_related = ('assignment', 'course', 'student', 'student__user')
    list_filter = (
        'assignment',
        ('course', RelatedOnlyDropdownFilter),
        ('student__user', RelatedOnlyDropdownFilter),
        'is_completed',
    )
    raw_id_fields = ('assignment', 'student',)
    readonly_fields = ('course',)

    fields = (
        'assignment', 'course', 'student', 'is_completed',
    )
