# Generated by Django 3.0.11 on 2022-03-11 11:48

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import simple_history.models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('courses', '0058_course_type'),
    ]

    operations = [
        migrations.CreateModel(
            name='Assignment',
            fields=[
                ('coursemodule_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='courses.CourseModule')),
            ],
            options={
                'ordering': ('order',),
                'abstract': False,
            },
            bases=('courses.coursemodule',),
        ),
        migrations.CreateModel(
            name='HistoricalAssignmentStudentResult',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_completed', models.BooleanField(default=False, verbose_name='завершено')),
                ('history_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('assignment', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='assignments.Assignment', verbose_name='задание')),
                ('course', models.ForeignKey(blank=True, db_constraint=False, editable=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.Course', verbose_name='курс')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('student', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.CourseStudent', verbose_name='студент')),
            ],
            options={
                'verbose_name': 'historical assignment student result',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='AssignmentStudentResult',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_completed', models.BooleanField(default=False, verbose_name='завершено')),
                ('assignment', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='results', to='assignments.Assignment', verbose_name='задание')),
                ('course', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='assignment_student_results', to='courses.Course', verbose_name='курс')),
                ('student', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='assignment_results', to='courses.CourseStudent', verbose_name='студент')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
