from django.db import models, transaction
from django.dispatch import receiver

from lms.assignments.models import Assignment, AssignmentStudentResult
from lms.courses.services import refresh_course_module_weight_sum_cache


@receiver(signal=models.signals.post_save, sender=AssignmentStudentResult)
def assignment_student_result_post_save_handler(instance: AssignmentStudentResult, **kwargs):
    module_progress = 0 if not instance.is_completed else 100
    instance.assignment.update_progress(student=instance.student, value=module_progress, force=True)


@receiver(signal=models.signals.post_delete, sender=Assignment)
def assignment_post_delete_handler(instance: Assignment, **kwargs):
    transaction.on_commit(lambda: refresh_course_module_weight_sum_cache(course_id=instance.course_id))


@receiver(signal=models.signals.post_save, sender=Assignment)
def assignment_post_save_handler(instance: Assignment, created: bool, **kwargs):
    if created or instance.field_tracker.has_changed('weight') or instance.field_tracker.has_changed('is_active'):
        transaction.on_commit(lambda: refresh_course_module_weight_sum_cache(course_id=instance.course_id))
