from rest_framework import serializers

from lms.courses.serializers import (
    CourseModuleCreateBaseSerializer, CourseModuleDetailBaseSerializer, CourseModuleUpdateBaseSerializer,
)

from .models import Assignment, AssignmentStudentResult


# API
# ===
class AssignmentDetailSerializer(serializers.ModelSerializer):
    class Meta:
        model = Assignment
        fields = (
            'id', 'name', 'description', 'estimated_time',
        )
        read_only_fields = fields


class AssignmentStudentResultDetailSerializer(serializers.ModelSerializer):
    class Meta:
        model = AssignmentStudentResult
        fields = (
            'is_completed',
        )
        read_only_fields = fields


# LABAPI
# ===
class AssignmentDetailLabSerializer(CourseModuleDetailBaseSerializer):
    class Meta(CourseModuleDetailBaseSerializer.Meta):
        model = Assignment


class AssignmentCreateLabSerializer(CourseModuleCreateBaseSerializer):
    class Meta(CourseModuleCreateBaseSerializer.Meta):
        model = Assignment
        fields = CourseModuleCreateBaseSerializer.Meta.fields + (
            'estimated_time',
        )


class AssignmentUpdateLabSerializer(CourseModuleUpdateBaseSerializer):
    class Meta(CourseModuleUpdateBaseSerializer.Meta):
        model = Assignment
        fields = CourseModuleUpdateBaseSerializer.Meta.fields + (
            'estimated_time',
        )
