from drf_spectacular.utils import extend_schema

from django.utils.translation import gettext

from lms.core.views.viewsets import LabModelViewSet
from lms.courses.permissions import CourseObjectPermission
from lms.courses.views import GetCourseMixin

from ..models import Assignment
from ..serializers import AssignmentCreateLabSerializer, AssignmentDetailLabSerializer, AssignmentUpdateLabSerializer


class AssignmentLabViewSet(GetCourseMixin, LabModelViewSet):
    serializer_class = AssignmentDetailLabSerializer
    serializer_classes = {
        'create': AssignmentCreateLabSerializer,
        'update': AssignmentUpdateLabSerializer,
        'partial_update': AssignmentUpdateLabSerializer,
        'retrieve': AssignmentDetailLabSerializer,
    }
    queryset = Assignment.objects.all()
    permission_classes = LabModelViewSet.permission_classes + [CourseObjectPermission]

    @extend_schema(
        responses={200: AssignmentDetailLabSerializer},
        summary=gettext("Информация о задании")
    )
    def retrieve(self, request, *args, **kwargs):
        return super().retrieve(request, *args, **kwargs)

    @extend_schema(
        request=AssignmentCreateLabSerializer,
        responses={201: AssignmentDetailLabSerializer},
        summary=gettext("Создание задания"),
    )
    def create(self, request, *args, **kwargs):
        return super().create(request, *args, **kwargs)

    @extend_schema(
        request=AssignmentUpdateLabSerializer,
        responses={200: AssignmentDetailLabSerializer},
        summary=gettext("Обновление задания"),
    )
    def update(self, request, *args, **kwargs):
        return super().update(request, *args, **kwargs)

    @extend_schema(
        request=AssignmentUpdateLabSerializer,
        responses={200: AssignmentDetailLabSerializer},
        summary=gettext("Частичное обновление задания"),
    )
    def partial_update(self, request, *args, **kwargs):
        return super().partial_update(request, *args, **kwargs)

    @extend_schema(
        summary=gettext("Удаление задания"),
    )
    def destroy(self, request, *args, **kwargs):
        return super().destroy(request, *args, **kwargs)
