from django.contrib import admin

from lms.calendars.models import CalendarEvent, CalendarLayer


@admin.register(CalendarLayer)
class CalendarLayerAdmin(admin.ModelAdmin):
    list_display = ('id', 'course',)
    list_select_related = ('course',)
    search_fields = (
        'id', 'course__name',
    )
    raw_id_fields = ('course',)


@admin.register(CalendarEvent)
class CalendarEventAdmin(admin.ModelAdmin):
    list_display = ('id', 'course', 'timeslot')
    list_select_related = ('course', 'timeslot')
    search_fields = (
        'id', 'course__name',
    )
    raw_id_fields = ('course', 'timeslot',)
