# Generated by Django 3.0.11 on 2022-03-09 10:48

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('classrooms', '0008_timeslotexchange_keep_previous_slots'),
        ('courses', '0058_course_type'),
    ]

    operations = [
        migrations.CreateModel(
            name='CalendarLayer',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('id', models.IntegerField(help_text='Идентификатор в календаре', primary_key=True, serialize=False, verbose_name='ID в Календаре')),
                ('course', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='calendar_layer', to='courses.Course', verbose_name='курс')),
            ],
            options={
                'verbose_name': 'Календарь',
                'verbose_name_plural': 'Календари',
            },
        ),
        migrations.CreateModel(
            name='CalendarEvent',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('id', models.IntegerField(help_text='Идентификатор в календаре', primary_key=True, serialize=False, verbose_name='ID в Календаре')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='calendar_events', to='courses.Course', verbose_name='курс')),
                ('timeslot', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='calendar_event', to='classrooms.Timeslot', verbose_name='Таймслот')),
            ],
            options={
                'verbose_name': 'встреча в календаре',
                'verbose_name_plural': 'встречи в календаре',
            },
        ),
    ]
