from model_utils.models import TimeStampedModel

from django.db import models
from django.utils.translation import gettext_lazy as _

from lms.classrooms.models import Timeslot
from lms.courses.models import Course


class CalendarLayer(TimeStampedModel):
    id = models.IntegerField(
        verbose_name=_("ID в Календаре"),
        help_text=_("Идентификатор в календаре"),
        primary_key=True,
    )
    course = models.OneToOneField(
        Course,
        verbose_name=_("курс"),
        related_name='calendar_layer',
        on_delete=models.CASCADE,
    )

    class Meta:
        verbose_name = _("Календарь")
        verbose_name_plural = _("Календари")

    def __str__(self):
        return f'Course: {self.course_id}.'


class CalendarEvent(TimeStampedModel):
    id = models.IntegerField(
        verbose_name=_("ID в Календаре"),
        help_text=_("Идентификатор в календаре"),
        primary_key=True,
    )
    course = models.ForeignKey(
        Course,
        verbose_name=_("курс"),
        related_name='calendar_events',
        on_delete=models.CASCADE,
    )
    timeslot = models.OneToOneField(
        Timeslot,
        verbose_name=_("Таймслот"),
        related_name='calendar_event',
        on_delete=models.CASCADE,
    )

    class Meta:
        verbose_name = _("встреча в календаре")
        verbose_name_plural = _("встречи в календаре")

    def __str__(self):
        return f'Course: {self.course_id}; Timeslot: {self.timeslot_id}.'
