import logging

from config import celery_app as app
from lms.calendars import services

log = logging.getLogger(__name__)


@app.task(bind=True)
def create_layer_for_course_task(self, course_id):
    try:
        services.get_or_create_calendar_layer(course_id)
    except Exception as exc:
        log.exception(exc)
        raise self.retry(exc=exc, max_retries=5, countdown=60)


@app.task(bind=True)
def create_event_for_timeslot_task(self, timeslot_id):
    try:
        services.get_or_create_calendar_event(timeslot_id)
    except Exception as exc:
        log.exception(exc)
        raise self.retry(exc=exc, max_retries=5, countdown=60)


@app.task(bind=True)
def update_event_for_timeslot_task(self, timeslot_id):
    try:
        services.update_calendar_event(timeslot_id)
    except Exception as exc:
        log.exception(exc)
        raise self.retry(exc=exc, max_retries=5, countdown=60)


@app.task(bind=True)
def update_student_event_attendance_task(self, timeslot_id, student_id):
    try:
        services.update_student_event_attendance(timeslot_id=timeslot_id, student_id=student_id)
    except Exception as exc:
        log.exception(exc)
        raise self.retry(exc=exc, max_retries=5, countdown=60)


@app.task(bind=True)
def delete_calendar_event_task(self, event_id):
    try:
        services.delete_calendar_event(event_id=event_id)
    except Exception as exc:
        log.exception(exc)
        raise self.retry(exc=exc, max_retries=5, countdown=60)


@app.task(bind=True)
def update_timeslot_dates_from_calendar_task(self, timeslot_id):
    try:
        services.update_timeslot_dates_from_calendar(timeslot_id=timeslot_id)
    except Exception as exc:
        log.exception(exc)
        raise self.retry(exc=exc, max_retries=5, countdown=60)
