# Generated by Django 2.2.15 on 2020-12-16 07:24

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('courses', '0033_coursemodule'),
    ]

    operations = [
        migrations.CreateModel(
            name='Classroom',
            fields=[
                ('coursemodule_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='courses.CourseModule')),
            ],
            options={
                'verbose_name': 'Занятие c расписанием',
                'verbose_name_plural': 'Занятия с расписанием',
            },
            bases=('courses.coursemodule',),
        ),
        migrations.CreateModel(
            name='Timeslot',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('begin_date', models.DateTimeField(verbose_name='дата начала')),
                ('end_date', models.DateTimeField(blank=True, null=True, verbose_name='дата окончания')),
                ('title', models.CharField(blank=True, max_length=255, verbose_name='заголовок')),
                ('summary', models.TextField(blank=True, verbose_name='краткое описание')),
                ('num_participants', models.PositiveIntegerField(default=0, editable=False, verbose_name='кол-во участников')),
                ('max_participants', models.PositiveIntegerField(default=0, verbose_name='макс кол-во участников')),
                ('classroom', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='timeslots', to='classrooms.Classroom', verbose_name='занятие')),
                ('course', models.ForeignKey(blank=True, null=True, editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='classroom_timeslots', to='courses.Course', verbose_name='курс')),
                ('course_groups', models.ManyToManyField(related_name='classroom_timeslots', to='courses.CourseGroup', verbose_name='группы')),
            ],
            options={
                'verbose_name': 'временной слот',
                'verbose_name_plural': 'временные слоты',
                'ordering': ('classroom', 'begin_date', '-created'),
            },
        ),
    ]
