# Generated by Django 3.0.11 on 2021-12-08 15:41

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('courses', '0056_rename_grade_column'),
        ('classrooms', '0006_student_slot_cancelled_status'),
    ]

    operations = [
        migrations.CreateModel(
            name='TimeslotExchange',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('id', model_utils.fields.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('is_active', models.BooleanField(default=True, verbose_name='активен')),
                ('course', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='timeslot_exchanges', to='courses.Course', verbose_name='Курс')),
                ('student_slot', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='exchanges', to='classrooms.StudentSlot', verbose_name='Запись на слот')),
                ('target_timeslot', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='exchanges', to='classrooms.Timeslot', verbose_name='Целевой слот')),
            ],
            options={
                'verbose_name': 'обмен слотами',
                'verbose_name_plural': 'обмены слотами',
            },
        ),
    ]
