from django.utils.translation import gettext_lazy as _

from rest_framework.exceptions import ValidationError

from .models import StudentSlot


class StudentSlotMixin:
    def get_object(self) -> 'StudentSlot':
        queryset = super().get_queryset()
        timeslot_id = self.get_timeslot_id()

        try:
            return queryset.get(
                timeslot_id=timeslot_id,
                student__user=self.request.user,
                status=StudentSlot.StatusChoices.ACCEPTED,
            )
        except StudentSlot.DoesNotExist:
            raise ValidationError(_('Нет записи на слот'), code='no_student_slot')

    def get_timeslot_id(self):
        return self.kwargs['pk']
