import logging

from config import celery_app as app

from . import services

log = logging.getLogger(__name__)


@app.task(bind=True)
def reject_from_slot_on_expell_student_task(self, student_id: int):
    try:
        services.reject_from_slot_on_expell_student(student_id=student_id)
    except Exception as exc:
        log.error(exc)
        raise self.retry(exc=exc, max_retries=5, countdown=60)
