from django.utils.translation import gettext_lazy as _

from rest_framework import serializers

from lms.courses.models import Course, CourseGroup


def validate_course_groups(course_groups, course: Course):
    not_found_groups = set(course_groups) - set(
        CourseGroup.objects.filter(id__in=course_groups, course_id=course).values_list('id', flat=True)
    )
    if not_found_groups:
        raise serializers.ValidationError({
            'course_groups': _('Группы не найдены в текущем курсе')
        })
