from blackbox import JsonBlackbox

from lms.contrib.tvm.client import tvm2_client


class BlackboxTVM2(JsonBlackbox):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

        blackbox_client = kwargs.get('blackbox_client', None)
        if blackbox_client:
            self.use_tvm2 = True
            self.blackbox_client_id = blackbox_client.value
            self.tvm2_client = tvm2_client
