from django.conf import settings

# Базовый URL Staff API
STAFF_API_BASE_URL = getattr(settings, 'STAFF_API_BASE_URL', 'https://staff-api.yandex-team.ru/v3/')

# Метод авторизации на Staff API: OAuth или TVM2. По умолчанию: OAuth
STAFF_API_OAUTH_METHOD_NAME = 'OAuth'
STAFF_API_TVM2_METHOD_NAME = 'TVM2'

STAFF_API_AUTH_METHOD = getattr(settings, 'STAFF_API_AUTH_METHOD', STAFF_API_OAUTH_METHOD_NAME)

# Токен для доступа к Staff API
STAFF_API_OAUTH_TOKEN = getattr(settings, 'STAFF_API_OAUTH_TOKEN', None)

# ID для TVM-авторизации на Staff API
STAFF_API_TVM_ID = getattr(settings, 'STAFF_API_TVM_ID', None)

# Отключение запросов к Staff API (только для CI)
STAFF_API_SKIP_TEST = getattr(settings, 'STAFF_API_SKIP_TEST', False)

# Язык на Стаффе по умолчанию
STAFF_DEFAULT_LANGUAGE = 'ru'

# Частота обновления активных профилей со Стаффа, в секундах
STAFF_PROFILE_REFRESH_TIME = getattr(settings, 'STAFF_PROFILE_REFRESH_TIME', 86400)  # одни сутки

# Время, после которого считаем профиль пользователя не активным (в секундах)
STAFF_PROFILE_INACTIVE_TIME = getattr(settings, 'STAFF_PROFILE_INACTIVE_TIME', 30 * 86400)  # 30 дней

# Количество неактивных профилей, обрабатываемых за раз
STAFF_PROFILE_INACTIVE_LIMIT = getattr(settings, 'STAFF_PROFILE_INACTIVE_LIMIT', 1000)

# Количество профилей, запрашиваемых в одном запросе
STAFF_PROFILE_CHUNK_SIZE = getattr(settings, 'STAFF_PROFILE_CHUNK_SIZE', 100)

# Формат ключа в кэше, для хранения флага об актуальности профиля
STAFF_PROFILE_UPDATED_CACHE_KEY = 'staff_profile_updated_{}'

# Раз в сколько секунд можно запускать обновления стафф-профиля пользователя
STAFF_PROFILE_UPDATE_TIMEOUT = getattr(settings, 'STAFF_PROFILE_UPDATE_TIMEOUT', 60)

# Время жизни кэша с именами групп для пользователя
STAFF_PROFILE_GROUP_NAMES_TIMEOUT = getattr(settings, 'STAFF_PROFILE_GROUP_NAMES_TIMEOUT', 3600)

# Время жизни кэша staff_city_id -> course_city_id
STAFF_CITY_COURSE_CITY_MAP_TTL = getattr(settings, 'STAFF_CITY_COURSE_CITY_MAP_TTL', 86_400)
