from django.contrib.auth import get_user_model
from django.contrib.auth.models import AnonymousUser

from rest_framework.authentication import BaseAuthentication

User = get_user_model()


class TVMUserTicketAuthentication(BaseAuthentication):
    tvm_param = 'tvm_uid'
    user_field = 'yauid'

    def get_user(self, userid):
        try:
            return User.objects.get(**{self.user_field: userid})
        except User.DoesNotExist:
            return AnonymousUser()

    def authenticate(self, request):
        userid = getattr(request._request, self.tvm_param, None)
        if not userid:
            return None

        user = self.get_user(userid)
        return user, None
