from tvm2 import TVM2, TVM2_USE_DAEMON
from tvm2.protocol import BlackboxClientId

from django.conf import settings
from django.utils.functional import SimpleLazyObject


def get_client() -> TVM2:
    allowed_clients = getattr(settings, 'TVM_ALLOWED_CLIENTS', [])
    blackbox_client = getattr(BlackboxClientId, settings.BLACKBOX_NAME)

    if TVM2_USE_DAEMON:
        return TVM2(
            client_id=settings.TVM_DEPLOY_SOURCE_ALIAS,
            blackbox_client=blackbox_client,
            allowed_clients=allowed_clients,
        )

    return TVM2(
        client_id=settings.TVM_CLIENT_ID,
        secret=settings.TVM_CLIENT_SECRET,
        blackbox_client=blackbox_client,
        allowed_clients=allowed_clients,
    )


tvm2_client = SimpleLazyObject(lambda: get_client())
