from django.db import models
from django.utils.translation import gettext_lazy as _


class ActiveFilterMixin:
    def active(self):
        return self.filter(is_active=True)  # noqa


class ActiveModelMixin(models.Model):
    is_active = models.BooleanField(_("активна"), default=True)

    class Meta:
        abstract = True


class HrdbIdModelMixin(models.Model):
    hrdb_id = models.IntegerField(
        verbose_name=_("ID в HRDB"),
        help_text=_("Идентификатор в базе HRDB"),
        null=True,
        blank=True,
        unique=True,
    )

    class Meta:
        abstract = True
