from rest_framework.viewsets import ModelViewSet

from .mixins import (
    ActionSerializerMixin, ApiAllowedTVMServiceMixin, CreateWithRetrieveModelMixin, DeleteProtectedModelMixin,
    LabApiAllowedTVMServiceMixin, LabPermissionsMixin, TVMUidMixin, UpdateWithRetrieveModelMixin,
)


class BaseModelViewSet(
    ActionSerializerMixin,
    TVMUidMixin,
    CreateWithRetrieveModelMixin,
    UpdateWithRetrieveModelMixin,
    DeleteProtectedModelMixin,
    ModelViewSet,
):
    """
    Базовый ViewSet для API Ручек и Лаборатории
    """
    pass


class APIModelViewSet(
    ApiAllowedTVMServiceMixin,
    BaseModelViewSet,
):
    """
    Дефолтный ViewSet для API Ручек
    """
    pass


class LabModelViewSet(
    LabPermissionsMixin,
    LabApiAllowedTVMServiceMixin,
    BaseModelViewSet,
):
    """
    Дефолтный ViewSet для Лаборатории
    """
    pass


class ExternalModelViewSet(
    BaseModelViewSet,
):
    """
    Дефолтный ViewSet для Внешнего API
    """
    pass
