from typing import Type

from .base import BaseRule
from .course import CohortRule
from .staff import (
    StaffCityRule, StaffGroupRule, StaffIsDeputyRule, StaffIsHeadRule, StaffJoinedDateRule, StaffLeadershipDateRule,
    StaffLeadershipPeriodRule, StaffOfficeRule, StaffWorkPeriodRule,
)

__all__ = [
    'BaseRule',
    'StaffCityRule',
    'StaffGroupRule',
    'StaffIsHeadRule',
    'StaffIsDeputyRule',
    'StaffJoinedDateRule',
    'StaffLeadershipDateRule',
    'StaffLeadershipPeriodRule',
    'StaffOfficeRule',
    'StaffWorkPeriodRule',
    'CohortRule',
]


def get_rule(name: str) -> Type[BaseRule]:
    return BaseRule.get_rule(name)
