from django.contrib.auth import get_user_model

from ..validators import SubsetValidator
from .base import BaseRule

User = get_user_model()


class CohortRule(BaseRule):
    label = 'cohort'
    validator_class = SubsetValidator

    def get_user_data(self, user: User):
        if not hasattr(user, '_cached_cohorts'):
            user._cached_cohorts = list(user.cohorts.values_list('pk', flat=True))

        return user._cached_cohorts
