
RULES_SCHEMA = {
    "definitions": {
        "root": {
            "type": "object",
            "properties": {
                "and": {"$ref": "#/definitions/and"},
                "or": {"$ref": "#/definitions/or"},
                "eq": {"$ref": "#/definitions/eq"},
                "ne": {"$ref": "#/definitions/ne"},
            },
            "minProperties": 1,
            "maxProperties": 1,
            "additionalProperties": False,
        },
        "operation": {
            "type": "array",
            "maxItems": 2,
            "items": [
                {"type": "string"},
            ],
            "additionalItems": True,
        },

        "and": {
            "type": "array",
            "minItems": 1,
            "items": {
                "$ref": "#/definitions/root"
            }
        },
        "or": {
            "type": "array",
            "minItems": 1,
            "items": {
                "$ref": "#/definitions/root",
            }
        },
        "eq": {
            "$ref": "#/definitions/operation",
        },
        "ne": {
            "$ref": "#/definitions/operation",
        },
    },

    "$ref": "#/definitions/root",
}
