from datetime import datetime
from typing import Optional

from django.utils.dateparse import parse_date, parse_datetime


def str_to_date(value: str) -> Optional[datetime]:
    dt = parse_date(value) or parse_datetime(value)
    if isinstance(dt, datetime):
        dt = dt.date()
    return dt
