# Generated by Django 2.2.13 on 2020-06-25 02:25

from django.conf import settings
from django.db import migrations, models
import django.utils.timezone
import model_utils.fields


def obsoleted_content_upload_path(instance, filename=None):
    return filename or instance.filename


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Course',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('begin_date', models.DateTimeField(verbose_name='начало обучения')),
                ('end_date', models.DateTimeField(verbose_name='окончание обучения')),
                ('enroll_begin', models.DateTimeField(verbose_name='начало зачисления')),
                ('enroll_end', models.DateTimeField(verbose_name='окончание зачисления')),
                ('slug', models.SlugField(blank=True, max_length=255, verbose_name='код')),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('shortname', models.CharField(blank=True, max_length=255, verbose_name='краткое название')),
                ('summary', models.CharField(blank=True, max_length=500, verbose_name='аннотация')),
                ('description', models.TextField(blank=True, verbose_name='описание')),
                ('is_active', models.BooleanField(default=True, verbose_name='активен')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='courses', to=settings.AUTH_USER_MODEL, verbose_name='автор')),
            ],
            options={
                'verbose_name': 'курс',
                'verbose_name_plural': 'курсы',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='CourseCity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('is_active', models.BooleanField(default=True, verbose_name='активен')),
            ],
            options={
                'verbose_name': 'город',
                'verbose_name_plural': 'города',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='CourseGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('slug', models.SlugField(blank=True, max_length=255, verbose_name='код')),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('summary', models.CharField(blank=True, max_length=500, verbose_name='краткое описание')),
                ('is_active', models.BooleanField(default=True, verbose_name='активен')),
                ('can_join', models.BooleanField(default=True, verbose_name='активен')),
                ('num_participants', models.PositiveIntegerField(default=0, editable=False, verbose_name='кол-во участников')),
                ('max_participants', models.PositiveIntegerField(default=0, verbose_name='макс кол-во участников')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='groups', to='courses.Course', verbose_name='курс')),
                ('members', models.ManyToManyField(related_name='group', to=settings.AUTH_USER_MODEL, verbose_name='участники')),
            ],
            options={
                'verbose_name': 'группа студентов',
                'verbose_name_plural': 'группы студентов',
                'ordering': ('begin_date', 'name'),
            },
        ),
        migrations.CreateModel(
            name='PricingModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False, verbose_name='order')),
                ('slug', models.SlugField(blank=True, max_length=255, verbose_name='код')),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('description', models.TextField(blank=True, verbose_name='описание')),
                ('is_active', models.BooleanField(default=True, verbose_name='активна')),
            ],
            options={
                'verbose_name': 'форма оплаты',
                'verbose_name_plural': 'формы оплаты',
                'ordering': ('order',),
            },
        ),
        migrations.CreateModel(
            name='StudyMode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False, verbose_name='order')),
                ('slug', models.SlugField(blank=True, max_length=255, verbose_name='код')),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('description', models.TextField(blank=True, verbose_name='описание')),
                ('is_active', models.BooleanField(default=True, verbose_name='активна')),
            ],
            options={
                'verbose_name': 'форма обучения',
                'verbose_name_plural': 'формы обучения',
                'ordering': ('order',),
            },
        ),
        migrations.CreateModel(
            name='Provider',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('description', models.TextField(blank=True, verbose_name='описание')),
                ('is_active', models.BooleanField(default=True, verbose_name='активен')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='created_providers', to=settings.AUTH_USER_MODEL, verbose_name='создано')),
            ],
            options={
                'verbose_name': 'провайдер',
                'verbose_name_plural': 'провайдеры',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='CourseFile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False, verbose_name='order')),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('content', models.FileField(upload_to=obsoleted_content_upload_path, verbose_name='файл')),
                ('size', models.PositiveIntegerField(default=0, verbose_name='размер файла')),
                ('mimetype', models.CharField(blank=True, max_length=255, verbose_name='тип файла')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='files', to='courses.Course', verbose_name='курс')),
                ('uploaded_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='uploaded_course_files', to=settings.AUTH_USER_MODEL, verbose_name='создано')),
            ],
            options={
                'verbose_name': 'файл для курса',
                'verbose_name_plural': 'файлы для курсов',
                'ordering': ('order',),
            },
        ),
        migrations.CreateModel(
            name='CourseCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False, verbose_name='order')),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('description', models.TextField(blank=True, verbose_name='описание')),
                ('is_active', models.BooleanField(default=True, verbose_name='активен')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='created_course_categories', to=settings.AUTH_USER_MODEL, verbose_name='создано')),
            ],
            options={
                'verbose_name': 'категория курса',
                'verbose_name_plural': 'категории курсов',
                'ordering': ('name',),
            },
        ),
        migrations.AddField(
            model_name='course',
            name='category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='courses', to='courses.CourseCategory', verbose_name='категория'),
        ),
        migrations.AddField(
            model_name='course',
            name='city',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='courses', to='courses.CourseCity', verbose_name='город'),
        ),
        migrations.AddField(
            model_name='course',
            name='pricing_model',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='courses', to='courses.PricingModel', verbose_name='форма оплаты'),
        ),
        migrations.AddField(
            model_name='course',
            name='provider',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='courses', to='courses.Provider', verbose_name='провайдер'),
        ),
        migrations.AddField(
            model_name='course',
            name='study_mode',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='courses', to='courses.StudyMode', verbose_name='форма обучения'),
        ),
        migrations.CreateModel(
            name='CourseOverride',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('begin_date', models.DateTimeField(verbose_name='начало обучения')),
                ('end_date', models.DateTimeField(verbose_name='окончание обучения')),
                ('enroll_begin', models.DateTimeField(verbose_name='начало зачисления')),
                ('enroll_end', models.DateTimeField(verbose_name='окончание зачисления')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='overrides', to='courses.Course', verbose_name='курс')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='course_overrides', to='courses.CourseGroup', verbose_name='группа')),
            ],
            options={
                'verbose_name': 'переопределение настроек курса',
                'verbose_name_plural': 'переопределение настроек курсов',
                'unique_together': {('course', 'group')},
            },
        ),
    ]
