# Generated by Django 2.2.15 on 2020-08-25 00:21

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import django_ltree.fields
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('django_ltree', '__latest__'),
        ('preferences', '0001_initial'),
        ('courses', '0005_drop_course_category'),
    ]

    operations = [
        migrations.CreateModel(
            name='CourseCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('slug', models.SlugField(max_length=255, unique=True, verbose_name='код')),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('description', models.TextField(blank=True, verbose_name='описание')),
                ('is_active', models.BooleanField(default=True, verbose_name='активен')),
                ('color_theme', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='course_categories', to='preferences.ColorTheme', verbose_name='цветовая схема')),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='created_course_categories', to=settings.AUTH_USER_MODEL, verbose_name='создано')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='children', to='courses.CourseCategory', verbose_name='Родительская категория')),
            ],
            options={
                'verbose_name': 'категория курса',
                'verbose_name_plural': 'категории курсов',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='CategoryNode',
            fields=[
                ('path', django_ltree.fields.PathField(unique=True)),
                ('category', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='node', serialize=False, to='courses.CourseCategory', verbose_name='категория')),
            ],
            options={
                'verbose_name': 'узел категории',
                'verbose_name_plural': 'дерево категорий',
                'ordering': ('path',),
            },
        ),
        migrations.AddField(
            model_name='course',
            name='categories',
            field=models.ManyToManyField(blank=True, to='courses.CourseCategory', verbose_name='категории', related_name='courses'),
        ),
    ]
