# Generated by Django 2.2.15 on 2020-09-14 12:06

from django.db import migrations, models
from uuid import uuid4


def set_random_slug(apps, schema_editor):
    CourseCity = apps.get_model('courses', 'CourseCity')
    for course_city in CourseCity.objects.all():
        course_city.slug = str(uuid4())
        course_city.save(update_fields=['slug'])


class Migration(migrations.Migration):

    dependencies = [
        ('courses', '0011_slug_for_models'),
    ]

    operations = [
        migrations.RunPython(set_random_slug, migrations.RunPython.noop),
        migrations.AlterField(
            model_name='coursecity',
            name='slug',
            field=models.SlugField(max_length=255, unique=True, verbose_name='код'),
        ),
    ]
