# Generated by Django 2.2.15 on 2020-10-28 12:45

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('courses', '0020_delete_courseoverride'),
    ]

    operations = [
        migrations.CreateModel(
            name='CourseStudent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('status', models.CharField(choices=[('active', 'Активен'), ('expelled', 'Отчислен'), ('renew', 'Восстановлен')], default='active', max_length=20, verbose_name='статус')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='students', to='courses.Course', verbose_name='курс')),
                ('group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='students', to='courses.CourseGroup', verbose_name='группа')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='in_courses', to=settings.AUTH_USER_MODEL, verbose_name='пользователь')),
            ],
            options={
                'verbose_name': 'студент',
                'verbose_name_plural': 'студенты',
                'ordering': ('-created',),
                'unique_together': {('course', 'user', 'group')},
            },
        ),
    ]
