# Generated by Django 2.2.15 on 2021-01-19 17:00

from django.db import migrations


def set_groups(apps, schema_editor):
    Course = apps.get_model('courses', 'Course')
    Course.objects.filter(groups__isnull=False).update(enable_groups=True)


def unset_groups(apps, schema_editor):
    Course = apps.get_model('courses', 'Course')
    Course.objects.all().update(enable_groups=False)


class Migration(migrations.Migration):

    dependencies = [
        ('courses', '0031_course_enable_groups'),
    ]

    operations = [
        migrations.RunPython(set_groups, unset_groups)
    ]
