# Generated by Django 3.0.11 on 2021-04-27 09:06

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('courses', '0040_enrolled_user_student_link'),
    ]

    operations = [
        migrations.CreateModel(
            name='Tutor',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_internal', models.BooleanField(verbose_name='внутренний')),
                ('name', models.CharField(blank=True, max_length=1024, verbose_name='имя внешнего наставника')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email внешнего наставника')),
                ('url', models.CharField(blank=True, max_length=1024, verbose_name='ссылка по профиль внешнего наставника')),
                ('is_active', models.BooleanField(default=True, verbose_name='активен')),
                ('position', models.CharField(choices=[('coach', 'тренер'), ('teacher', 'преподаватель')], max_length=10, verbose_name='должность')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, verbose_name='внутренний наставник')),
            ],
            options={
                'verbose_name': 'наставник',
                'verbose_name_plural': 'наставники',
            },
        ),
        migrations.AddField(
            model_name='coursegroup',
            name='tutor',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='courses.Tutor', verbose_name='наставник'),
        ),
    ]
