# Generated by Django 3.0.11 on 2021-05-20 10:55

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import lms.courses.validators
import model_utils.fields
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('courses', '0041_tutor'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalCourseStudent',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('status', models.CharField(choices=[('active', 'Активен'), ('expelled', 'Отчислен'), ('completed', 'Завершил обучение')], default='active', max_length=20, verbose_name='статус')),
                ('history_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('course', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.Course', verbose_name='курс')),
                ('group', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.CourseGroup', verbose_name='группа')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('user', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='пользователь')),
            ],
            options={
                'verbose_name': 'historical студент',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalCourseGroup',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('hrdb_id', models.IntegerField(blank=True, db_index=True, help_text='Идентификатор в базе HRDB', null=True, verbose_name='ID в HRDB')),
                ('begin_date', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='начало обучения')),
                ('end_date', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='окончание обучения')),
                ('enroll_begin', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='начало зачисления')),
                ('enroll_end', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='окончание зачисления')),
                ('price', models.DecimalField(blank=True, decimal_places=2, help_text='Полная стоимость, запрашиваемая провайдером', max_digits=10, null=True, verbose_name='стоимость в каталоге')),
                ('payment_method', models.CharField(choices=[('free', 'Бесплатно'), ('corporate', 'За счет компании'), ('personal', 'С удержанием')], default='free', max_length=20, verbose_name='вариант оплаты')),
                ('paid_percent', models.IntegerField(default=0, help_text='Актуален, только если платит сотрудник', verbose_name='процент удержания')),
                ('payment_terms', models.TextField(blank=True, help_text='Описание условий оплаты, удержаний, стоимости для компании', verbose_name='условия оплаты')),
                ('num_hours', models.IntegerField(blank=True, help_text='Количество неакадемических часов', null=True, verbose_name='кол-во часов')),
                ('slug', models.SlugField(blank=True, max_length=255, verbose_name='код')),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('summary', models.CharField(blank=True, max_length=500, verbose_name='краткое описание')),
                ('is_active', models.BooleanField(default=True, verbose_name='активен')),
                ('can_join', models.BooleanField(default=True, verbose_name='можно ли записаться')),
                ('num_participants', models.PositiveIntegerField(default=0, editable=False, verbose_name='кол-во участников')),
                ('max_participants', models.PositiveIntegerField(default=0, verbose_name='макс кол-во участников')),
                ('history_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('course', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.Course', verbose_name='курс')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('tutor', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.Tutor', verbose_name='наставник')),
            ],
            options={
                'verbose_name': 'historical группа студентов',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalCourse',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('hrdb_id', models.IntegerField(blank=True, db_index=True, help_text='Идентификатор в базе HRDB', null=True, verbose_name='ID в HRDB')),
                ('begin_date', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='начало обучения')),
                ('end_date', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='окончание обучения')),
                ('enroll_begin', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='начало зачисления')),
                ('enroll_end', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='окончание зачисления')),
                ('price', models.DecimalField(blank=True, decimal_places=2, help_text='Полная стоимость, запрашиваемая провайдером', max_digits=10, null=True, verbose_name='стоимость в каталоге')),
                ('payment_method', models.CharField(choices=[('free', 'Бесплатно'), ('corporate', 'За счет компании'), ('personal', 'С удержанием')], default='free', max_length=20, verbose_name='вариант оплаты')),
                ('paid_percent', models.IntegerField(default=0, help_text='Актуален, только если платит сотрудник', verbose_name='процент удержания')),
                ('payment_terms', models.TextField(blank=True, help_text='Описание условий оплаты, удержаний, стоимости для компании', verbose_name='условия оплаты')),
                ('num_hours', models.IntegerField(blank=True, help_text='Количество неакадемических часов', null=True, verbose_name='кол-во часов')),
                ('enable_groups', models.BooleanField(default=False, editable=False, verbose_name='Наличие групп студентов')),
                ('enable_followers', models.BooleanField(default=False, help_text='разрешены все подписки на курс', verbose_name='разрешить подписки на курс')),
                ('format', models.CharField(choices=[('modular', 'Модули'), ('scorm', 'SCORM')], default='modular', max_length=20, verbose_name='структура курса')),
                ('slug', models.SlugField(max_length=255, validators=[lms.courses.validators.validate_course_slug], verbose_name='код')),
                ('name', models.CharField(max_length=255, verbose_name='название')),
                ('shortname', models.CharField(blank=True, max_length=255, verbose_name='краткое название')),
                ('summary', models.CharField(blank=True, max_length=500, verbose_name='аннотация')),
                ('description', models.TextField(blank=True, verbose_name='описание')),
                ('image_url', models.URLField(blank=True, max_length=500, verbose_name='обложка')),
                ('is_active', models.BooleanField(default=False, verbose_name='активен')),
                ('is_archive', models.BooleanField(default=False, verbose_name='в архиве')),
                ('calc_begin_date', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='фактическое начало обучения')),
                ('calc_end_date', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='фактическое окончание обучения')),
                ('calc_enroll_begin', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='фактическое начало зачисления')),
                ('calc_enroll_end', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='фактическое окончание зачисления')),
                ('structure', models.CharField(choices=[('no_modules', 'Без модулей'), ('single_module', 'Один модуль'), ('multi_modules', 'Несколько модулей')], default='no_modules', max_length=20, verbose_name='структура курса')),
                ('enrollments_only', models.BooleanField(default=False, help_text='\n            При записи на курс создаются только заявки.\n            Записи о студентах не создаются.\n            Прохождение курса не отслеживается\n        ', verbose_name='только заявки')),
                ('multi_enrollments', models.BooleanField(default=False, help_text='Пользователь может подать на курс несколько заявок', verbose_name='множественные заявки')),
                ('retries_allowed', models.BooleanField(default=False, help_text='После завершения курса пользователь может снова записаться на курс и пройти его', verbose_name='повторное прохождение')),
                ('show_in_catalog', models.BooleanField(default=True, help_text='если не указано, то курс будет доступен только по прямой ссылке', verbose_name='показать в каталоге')),
                ('history_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('author', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='автор')),
                ('city', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.CourseCity', verbose_name='город')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('provider', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.Provider', verbose_name='провайдер')),
                ('study_mode', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.StudyMode', verbose_name='форма обучения')),
                ('workflow', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.CourseWorkflow', verbose_name='воркфлоу')),
            ],
            options={
                'verbose_name': 'historical курс',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
