# Generated by Django 3.0.11 on 2021-06-17 10:42

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import lms.core.validators
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('courses', '0042_course_history'),
    ]

    operations = [
        migrations.CreateModel(
            name='Cohort',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(blank=True, max_length=255, verbose_name='название')),
                ('status', models.CharField(choices=[('pending', 'в обработке'), ('ready', 'готова'), ('error', 'ошибка')], default='pending', max_length=16, verbose_name='статус')),
                ('logins', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=list, validators=[lms.core.validators.list_of_logins_validator], verbose_name='список логинов')),
                ('is_active', models.BooleanField(default=True, verbose_name='активна')),
                ('course', models.ForeignKey(blank=True, help_text='курс, которому относится когорта (null - глобальная когорта)', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='cohorts', to='courses.Course', verbose_name='курс')),
                ('users', models.ManyToManyField(blank=True, related_name='cohorts', to=settings.AUTH_USER_MODEL, verbose_name='состав когорты')),
            ],
            options={
                'verbose_name': 'когорта',
                'verbose_name_plural': 'когорты',
                'ordering': ('-course', 'name'),
            },
        ),
    ]
