# Generated by Django 3.0.11 on 2021-06-15 22:42

from django.db import migrations
from django_celery_beat.models import (
    HOURS
)

process_pending_cohort_periodic_task_name = 'Update cohort users'
process_pending_cohort_periodic_task_path = 'lms.courses.tasks.process_pending_cohort_periodic_task'


def forward(apps, schema_editor):
    IntervalSchedule = apps.get_model('django_celery_beat', 'IntervalSchedule')
    PeriodicTask = apps.get_model('django_celery_beat', 'PeriodicTask')

    interval, _ = IntervalSchedule.objects.get_or_create(
        period=HOURS,
        every=1,
    )

    task1, _ = PeriodicTask.objects.get_or_create(
        name=process_pending_cohort_periodic_task_name,
        defaults={
            'task': process_pending_cohort_periodic_task_path,
            'interval': interval,
        },
    )


def backward(apps, schema_editor):
    PeriodicTask = apps.get_model('django_celery_beat', 'PeriodicTask')

    PeriodicTask.objects.filter(
        name=process_pending_cohort_periodic_task_name,
    ).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('django_celery_beat', '0006_auto_20180210_1226'),
        ('courses', '0043_cohorts'),
    ]

    operations = [
        migrations.RunPython(forward, backward),
    ]
