# Generated by Django 3.0.11 on 2021-10-07 16:07

from django.contrib.auth.hashers import UnsaltedSHA1PasswordHasher
from django.db import migrations, models


def forward_func(apps, schema_editor):
    CourseVisibility = apps.get_model('courses', 'CourseVisibility')
    course_visibilities = CourseVisibility.objects.all()
    hasher = UnsaltedSHA1PasswordHasher()
    for visibility in course_visibilities:
        visibility.rules_hash = hasher.encode(str(visibility.rules), '')
        visibility.save(update_fields=['rules_hash'])


class Migration(migrations.Migration):

    dependencies = [
        ('courses', '0049_course_student_multi_groups'),
    ]

    operations = [
        migrations.AddField(
            model_name='coursevisibility',
            name='rules_hash',
            field=models.CharField(db_index=True, max_length=64, blank=True, editable=False, verbose_name='хеш'),
        ),
        migrations.RunPython(forward_func, reverse_code=migrations.RunPython.noop),
    ]
