# Generated by Django 3.0.11 on 2021-10-25 15:06

from django.db import migrations, models


def forward(apps, schema_editor):
    CourseFile = apps.get_model('courses', 'CourseFile')
    course_files = CourseFile.objects.all()
    for course_file in course_files:
        course_file.status = 'success'
        course_file.save(update_fields=['status'])


class Migration(migrations.Migration):

    dependencies = [
        ('courses', '0051_cohort_error_messages'),
    ]

    operations = [
        migrations.RenameField(
            model_name='coursefile',
            old_name='name',
            new_name='filename',
        ),
        migrations.AddField(
            model_name='coursefile',
            name='folder',
            field=models.CharField(default='default', max_length=64, verbose_name='директория'),
        ),
        migrations.AddField(
            model_name='coursefile',
            name='status',
            field=models.CharField(choices=[('pending', 'в обработке'), ('success', 'успех'), ('error', 'ошибка')], default='pending', help_text='статус загрузки файла и готовности к использованию', max_length=10, verbose_name='статус'),
        ),
        migrations.AddField(
            model_name='coursefile',
            name='url',
            field=models.URLField(blank=True),
        ),
        migrations.RemoveField(
            model_name='coursefile',
            name='content',
        ),
        migrations.AlterModelOptions(
            name='coursefile',
            options={'ordering': ('-created',), 'verbose_name': 'файл для курса',
                     'verbose_name_plural': 'файлы для курсов'},
        ),
        migrations.RemoveField(
            model_name='coursefile',
            name='order',
        ),
        migrations.RunPython(forward, reverse_code=migrations.RunPython.noop)
    ]
