# Generated by Django 3.0.11 on 2021-11-08 11:35

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('courses', '0052_coursefile_path_and_status'),
    ]

    operations = [
        migrations.CreateModel(
            name='GradeColumn',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False, verbose_name='order')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('grade_type', models.CharField(choices=[('highest', 'высшая оценка'), ('latest', 'последняя оценка')], default='latest', max_length=16, verbose_name='тип оценки')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='grade_columns', to='courses.Course', verbose_name='курс')),
                ('module', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='grade_columns', to='courses.CourseModule', verbose_name='модуль')),
            ],
            options={
                'verbose_name': 'колонка оценок',
                'verbose_name_plural': 'колонки оценок',
                'ordering': ('order',),
            },
        ),
        migrations.CreateModel(
            name='Grade',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('score', models.PositiveIntegerField(default=0, validators=[django.core.validators.MaxValueValidator(100)], verbose_name='оценка')),
                ('column', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='grades', to='courses.GradeColumn', verbose_name='колонка')),
                ('course', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='grades', to='courses.Course', verbose_name='курс')),
                ('module', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.PROTECT, related_name='grades', to='courses.CourseModule', verbose_name='модуль')),
                ('student', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='grades', to='courses.CourseStudent', verbose_name='студент')),
            ],
            options={
                'verbose_name': 'оценка',
                'verbose_name_plural': 'оценки',
            },
        ),
    ]
