# Generated by Django 3.0.14 on 2022-03-22 13:24

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('courses', '0060_courseblock'),
    ]

    operations = [
        migrations.AddField(
            model_name='coursemodule',
            name='weight',
            field=models.PositiveSmallIntegerField(default=0, validators=[django.core.validators.MaxValueValidator(100)], verbose_name='вес'),
        ),
        migrations.AddField(
            model_name='coursemodule',
            name='weight_scaled',
            field=models.DecimalField(decimal_places=2, default=0.0, help_text='рассчитывается автоматически в зависимости от weight всех модулей в курсе', max_digits=3, validators=[django.core.validators.MaxValueValidator(1), django.core.validators.MinValueValidator(0)], verbose_name='абсолютная доля веса'),
        ),
        migrations.CreateModel(
            name='StudentModuleProgress',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('score', models.PositiveSmallIntegerField(default=0, validators=[django.core.validators.MaxValueValidator(100)], verbose_name='баллы')),
                ('score_scaled', models.DecimalField(decimal_places=2, default=0.0, max_digits=5, validators=[django.core.validators.MaxValueValidator(100), django.core.validators.MinValueValidator(0)], verbose_name='взвешенные баллы')),
                ('course', models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='module_progresses', to='courses.Course', verbose_name='курс')),
                ('module', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='progresses', to='courses.CourseModule', verbose_name='модуль')),
                ('student', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='module_progresses', to='courses.CourseStudent', verbose_name='студент')),
            ],
            options={
                'verbose_name': 'прогресс по модулю',
                'verbose_name_plural': 'прогресс по модулям',
            },
        ),
        migrations.CreateModel(
            name='StudentCourseProgress',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('score', models.PositiveSmallIntegerField(default=0, validators=[django.core.validators.MaxValueValidator(100)], verbose_name='баллы')),
                ('course', models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='course_progresses', to='courses.Course', verbose_name='курс')),
                ('student', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='course_progresses', to='courses.CourseStudent', verbose_name='студент')),
            ],
            options={
                'verbose_name': 'прогресс по курсу',
                'verbose_name_plural': 'прогресс по курсам',
            },
        ),
        migrations.CreateModel(
            name='HistoricalStudentCourseProgress',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('score', models.PositiveSmallIntegerField(default=0, validators=[django.core.validators.MaxValueValidator(100)], verbose_name='баллы')),
                ('history_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('course', models.ForeignKey(blank=True, db_constraint=False, editable=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.Course', verbose_name='курс')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('student', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.CourseStudent', verbose_name='студент')),
            ],
            options={
                'verbose_name': 'historical прогресс по курсу',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.AddConstraint(
            model_name='studentmoduleprogress',
            constraint=models.UniqueConstraint(fields=('student', 'module'), name='unique_student_module'),
        ),
        migrations.AddConstraint(
            model_name='studentcourseprogress',
            constraint=models.UniqueConstraint(fields=('student', 'course'), name='unique_student_course'),
        ),
    ]
