# Generated by Django 3.0.14 on 2022-04-04 17:05

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import lms.core.validators
import model_utils.fields
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('courses', '0062_course_progress_history'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalCohort',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(blank=True, max_length=255, verbose_name='название')),
                ('status', models.CharField(choices=[('pending', 'в обработке'), ('ready', 'готова'), ('error', 'ошибка')], default='pending', max_length=16, verbose_name='статус')),
                ('error_messages', models.TextField(blank=True, verbose_name='ошибки обработки логинов')),
                ('logins', django.contrib.postgres.fields.jsonb.JSONField(validators=[lms.core.validators.list_of_logins_validator], verbose_name='список логинов')),
                ('is_active', models.BooleanField(default=True, verbose_name='активна')),
                ('history_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('course', models.ForeignKey(blank=True, db_constraint=False, help_text='курс, которому относится когорта (null - глобальная когорта)', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.Course', verbose_name='курс')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical когорта',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
