from rest_framework import serializers

from ..models import Cohort, Course


# LABAPI Serializers
# ===============
class CohortListLabSerializer(serializers.ModelSerializer):
    class Meta:
        model = Cohort
        fields = (
            'id', 'name', 'status', 'logins', 'course_id', 'is_active',
            'created', 'modified',
        )


class CohortCreateLabSerializer(serializers.ModelSerializer):
    course_id = serializers.PrimaryKeyRelatedField(
        source='course', queryset=Course.objects.all(), required=True, allow_null=False,
    )

    class Meta:
        model = Cohort
        fields = (
            'name', 'logins', 'course_id', 'is_active',
        )


class CohortDetailLabSerializer(serializers.ModelSerializer):
    class Meta:
        model = Cohort
        fields = (
            'id', 'name', 'status', 'error_messages', 'logins', 'course_id', 'is_active',
            'created', 'modified',
        )


class CohortUpdateLabSerializer(serializers.ModelSerializer):
    class Meta:
        model = Cohort
        fields = (
            'name', 'logins', 'is_active',
        )
