from rest_framework import serializers

from lms.courses.models import Course, CourseBlock


# API
# ===
class CourseBlockListSerializer(serializers.ModelSerializer):
    class Meta:
        model = CourseBlock
        fields = (
            'id', 'name', 'summary',
        )
        read_only_fields = fields


class CourseBlockDetailSerializer(serializers.ModelSerializer):
    class Meta:
        model = CourseBlock
        fields = (
            'id', 'name', 'summary',
        )
        read_only_fields = fields


# LabAPI
# ======
class CourseBlockIdLabSerializer(serializers.Serializer):
    block_id = serializers.PrimaryKeyRelatedField(
        queryset=CourseBlock.objects.all(), required=True,
    )


class CourseBlockListLabSerializer(serializers.ModelSerializer):
    class Meta:
        model = CourseBlock
        fields = (
            'id', 'name', 'summary', 'is_active', 'created', 'modified',
        )
        read_only_fields = fields


class CourseBlockDetailLabSerializer(serializers.ModelSerializer):
    class Meta:
        model = CourseBlock
        fields = (
            'id', 'name', 'summary', 'is_active', 'created', 'modified',
        )
        read_only_fields = fields


class CourseBlockUpdateLabSerializer(serializers.ModelSerializer):
    class Meta:
        model = CourseBlock
        fields = (
            'name', 'summary', 'is_active',
        )


class CourseBlockCreateLabSerializer(serializers.ModelSerializer):
    """
    Создание блока
    """
    course_id = serializers.PrimaryKeyRelatedField(
        source='course', queryset=Course.objects.all(),
    )

    class Meta:
        model = CourseBlock
        fields = (
            'course_id', 'name', 'summary', 'is_active',
        )
