from drf_spectacular.types import OpenApiTypes
from drf_spectacular.utils import extend_schema_field

from rest_framework import serializers

from lms.contrib.s3.s3_boto_client import s3_boto_client

from ..models import Course, CourseFile


class CourseFileCreateLabSerializer(serializers.ModelSerializer):
    course_id = serializers.PrimaryKeyRelatedField(
        source='course', queryset=Course.objects.all(),
    )

    class Meta:
        model = CourseFile
        fields = (
            'course_id', 'filename',
        )


class CourseFileDetailLabSerializer(serializers.ModelSerializer):
    course_file_id = serializers.IntegerField(source='id')
    url = serializers.SerializerMethodField()

    @extend_schema_field(OpenApiTypes.URI)
    def get_url(self, obj: CourseFile):
        return s3_boto_client.generate_presigned_url(obj.file)

    class Meta:
        model = CourseFile
        fields = (
            'course_file_id', 'url'
        )
        read_only_fields = fields
