from rest_framework import serializers

from ..models import Course, CourseGroup, Tutor
from .tutor import TutorDetailLabSerializer, TutorDetailSerializer, TutorListLabSerializer


# API Serializers
# ===============
class CourseGroupListSerializer(serializers.ModelSerializer):
    begin_date = serializers.DateTimeField(source='get_begin_date')
    end_date = serializers.DateTimeField(source='get_end_date')
    enroll_begin = serializers.DateTimeField(source='get_enroll_begin')
    enroll_end = serializers.DateTimeField(source='get_enroll_end')
    tutor = TutorDetailSerializer()

    class Meta:
        model = CourseGroup
        fields = (
            'id', 'name', 'summary', 'tutor',
            'can_join', 'num_participants', 'max_participants', 'available_for_enroll', 'is_full',
            'is_enroll_open', 'enroll_will_begin', 'has_open_seats',
            'begin_date', 'end_date', 'enroll_begin', 'enroll_end',
        )
        read_only_fields = fields


# LabAPI Serializers
# ===============
class CourseGroupListLabSerializer(serializers.ModelSerializer):
    tutor = TutorListLabSerializer()

    class Meta:
        model = CourseGroup
        fields = (
            'id', 'course_id', 'slug', 'name', 'summary', 'is_active', 'tutor',
            'can_join', 'num_participants', 'max_participants', 'available_for_enroll', 'is_full',
            'is_enroll_open', 'enroll_will_begin', 'has_open_seats',
            'begin_date', 'end_date', 'enroll_begin', 'enroll_end',
        )


class CourseGroupDetailLabSerializer(serializers.ModelSerializer):
    tutor = TutorDetailLabSerializer()

    class Meta:
        model = CourseGroup
        fields = (
            'id', 'course_id', 'slug', 'name', 'summary', 'is_active', 'tutor',
            'can_join', 'num_participants', 'max_participants', 'available_for_enroll', 'is_full',
            'is_enroll_open', 'enroll_will_begin', 'has_open_seats',
            'begin_date', 'end_date', 'enroll_begin', 'enroll_end',
        )


class CourseGroupUpdateLabSerializer(serializers.ModelSerializer):
    course_id = serializers.PrimaryKeyRelatedField(
        source='course', queryset=Course.objects.all(),
    )
    tutor_id = serializers.PrimaryKeyRelatedField(
        source='tutor', queryset=Tutor.objects.active(), required=False, allow_null=True,
    )

    class Meta:
        model = CourseGroup
        fields = (
            'course_id', 'slug', 'name', 'summary', 'is_active', 'tutor_id',
            'can_join', 'max_participants',
            'begin_date', 'end_date', 'enroll_begin', 'enroll_end',
        )


class CourseGroupCreateLabSerializer(serializers.ModelSerializer):
    course_id = serializers.PrimaryKeyRelatedField(
        source='course', queryset=Course.objects.all(),
    )
    tutor_id = serializers.PrimaryKeyRelatedField(
        source='tutor', queryset=Tutor.objects.active(), required=False, allow_null=True,
    )

    class Meta:
        model = CourseGroup
        fields = (
            'course_id', 'slug', 'name', 'summary', 'is_active', 'tutor_id',
            'can_join', 'max_participants',
            'begin_date', 'end_date', 'enroll_begin', 'enroll_end',
        )


class CourseGroupInlineSerializer(serializers.ModelSerializer):
    class Meta:
        model = CourseGroup
        fields = ('id', 'name')
