from rest_framework import serializers

from lms.moduletypes.serializers import ModuleTypeDetailSerializer

from ..models import Course, CourseBlock, CourseModule


# API
# ===
class CourseModuleListSerializer(serializers.ModelSerializer):
    module_type = ModuleTypeDetailSerializer()

    class Meta:
        model = CourseModule
        fields = (
            'id', 'module_type', 'name', 'description', 'estimated_time', 'block_id',
        )
        read_only_fields = fields


class CourseModuleDetailSerializer(serializers.ModelSerializer):
    module_type = ModuleTypeDetailSerializer()

    class Meta:
        model = CourseModule
        fields = (
            'id', 'module_type', 'name', 'description', 'estimated_time', 'block_id',
        )
        read_only_fields = fields


# LabAPI
# ======
class CourseModuleListBaseSerializer(serializers.ModelSerializer):

    class Meta:
        model = CourseModule
        fields = (
            'id', 'name', 'description', 'is_active', 'estimated_time', 'block_id',
            'created', 'modified',
        )
        read_only_fields = fields


class CourseModuleListLabSerializer(CourseModuleListBaseSerializer):
    module_type = ModuleTypeDetailSerializer()

    class Meta(CourseModuleListBaseSerializer.Meta):
        fields = CourseModuleListBaseSerializer.Meta.fields + (
            'module_type',
        )
        read_only_fields = fields


class CourseModuleDetailBaseSerializer(serializers.ModelSerializer):

    class Meta:
        model = CourseModule
        fields = (
            'id', 'name', 'description', 'is_active', 'estimated_time', 'block_id',
            'created', 'modified',
        )
        read_only_fields = fields


class CourseModuleDetailLabSerializer(CourseModuleDetailBaseSerializer):
    module_type = ModuleTypeDetailSerializer()

    class Meta(CourseModuleDetailBaseSerializer.Meta):
        fields = CourseModuleDetailBaseSerializer.Meta.fields + (
            'module_type',
        )
        read_only_fields = fields


class CourseModuleIdLabSerializer(serializers.Serializer):
    module_id = serializers.PrimaryKeyRelatedField(
        queryset=CourseModule.objects.all(), required=True,
    )


class CourseModuleCreateBaseSerializer(serializers.ModelSerializer):
    course_id = serializers.PrimaryKeyRelatedField(
        source='course', queryset=Course.objects.all(),
    )
    block_id = serializers.PrimaryKeyRelatedField(
        source='block', queryset=CourseBlock.objects.all(), required=False, allow_null=True,
    )

    class Meta:
        model = CourseModule
        fields = ('course_id', 'block_id', 'name', 'description', 'is_active',)


class CourseModuleUpdateBaseSerializer(serializers.ModelSerializer):
    block_id = serializers.PrimaryKeyRelatedField(
        source='block', queryset=CourseBlock.objects.all(), required=False, allow_null=True,
    )

    class Meta:
        model = CourseModule
        fields = ('block_id', 'name', 'description', 'is_active',)
