from django.contrib.auth import get_user_model

from rest_framework import serializers

from ..models import CourseTeam

User = get_user_model()


class CourseTeamListLabSerializer(serializers.ModelSerializer):
    class Meta:
        model = CourseTeam
        fields = (
            'id', 'name',
        )
        read_only_fields = fields


class CourseTeamDetailLabSerializer(serializers.ModelSerializer):
    id = serializers.ReadOnlyField()

    class Meta:
        model = CourseTeam
        fields = (
            'id', 'name',
        )
        read_only_fields = fields


class CourseTeamUpdateLabSerializer(serializers.ModelSerializer):
    class Meta:
        model = CourseTeam
        fields = (
            'name',
        )


class CourseTeamCreateLabSerializer(serializers.ModelSerializer):
    class Meta:
        model = CourseTeam
        fields = (
            'name',
        )


class CourseTeamMemberSerializer(serializers.ModelSerializer):
    class Meta:
        model = User
        fields = (
            'id', 'username', 'first_name', 'last_name',
        )
        read_only_fields = fields


class CourseTeamMembersUpdateLabSerializer(serializers.ListSerializer):
    child = serializers.IntegerField()


class CourseTeamInCourseSerializer(serializers.ModelSerializer):
    class Meta:
        model = CourseTeam
        fields = (
            'id', 'name',
        )
        read_only_fields = fields


class CourseTeamInCourseUpdateSerializer(serializers.ListSerializer):
    child = serializers.IntegerField()
