from rest_framework import serializers

from ..models import CourseVisibility


# LabAPI Serializers
# ==================
class CourseVisibilityDetailLabSerializer(serializers.ModelSerializer):
    class Meta:
        model = CourseVisibility
        fields = (
            'course_id',
            'rules',
            'comments',
            'is_active',
            'created',
            'modified',
        )
        read_only_fields = fields


class CourseVisibilityUpdateLabSerializer(serializers.ModelSerializer):
    class Meta:
        model = CourseVisibility
        fields = (
            'rules',
            'comments',
            'is_active',
        )

    def validate(self, attrs):
        instance = CourseVisibility(**attrs)
        instance.clean()

        return attrs


class CourseVisibilityCheckLabSerializer(serializers.Serializer):
    visible = serializers.BooleanField()
